package com.zatackcoder.volumechangenotifier;

import android.content.Context;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.os.Handler;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.widget.CheckBox;
import android.widget.TextView;
import android.widget.Toast;

public class MainActivity extends AppCompatActivity {

    VolumeChangeObserver volumeChangeObserver;
    TextView textView;
    CheckBox checkBox;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        textView = findViewById(R.id.textview);
        checkBox = findViewById(R.id.checkbox);
        volumeChangeObserver = new VolumeChangeObserver(getApplicationContext(), new Handler());
        getApplicationContext().getContentResolver().registerContentObserver(android.provider.Settings.System.CONTENT_URI, true, volumeChangeObserver);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        getApplicationContext().getContentResolver().unregisterContentObserver(volumeChangeObserver);
    }

    class VolumeChangeObserver extends ContentObserver {

        Context context;
        int musicVolume, ringVolume, alarmVolume;

        public VolumeChangeObserver(Context context, Handler handler) {
            super(handler);
            this.context = context;

            AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
            musicVolume = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
            ringVolume = audioManager.getStreamVolume(AudioManager.STREAM_RING);
            alarmVolume = audioManager.getStreamVolume(AudioManager.STREAM_ALARM);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return super.deliverSelfNotifications();
        }

        @Override
        public void onChange(boolean selfChange) {
            super.onChange(selfChange);

            AudioManager audioManager = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);
            int mVolume = audioManager.getStreamVolume(AudioManager.STREAM_MUSIC);
            int rVolume = audioManager.getStreamVolume(AudioManager.STREAM_RING);
            int aVolume = audioManager.getStreamVolume(AudioManager.STREAM_ALARM);

            if(checkBox.isChecked()) {
                audioManager.setStreamVolume(AudioManager.STREAM_MUSIC, musicVolume, 0);
                audioManager.setStreamVolume(AudioManager.STREAM_RING, ringVolume, 0);
                audioManager.setStreamVolume(AudioManager.STREAM_ALARM, alarmVolume, 0);
                return;
            }
            int mDelta = musicVolume - mVolume;
            int rDelta = ringVolume - rVolume;
            int aDelta = alarmVolume - aVolume;

            if (mDelta > 0) {
                textView.setText("Music Volume Decreased");
                musicVolume = mVolume;
            } else if (mDelta < 0) {
                textView.setText("Music Volume Increased");
                musicVolume = mVolume;
            }

            if (rDelta > 0) {
                textView.setText("Ring Volume Decreased");
                ringVolume = rVolume;
            } else if (rDelta < 0) {
                textView.setText("Ring Volume Increased");
                ringVolume = rVolume;
            }

            if (aDelta > 0) {
                textView.setText("Alarm Volume Decreased");
                alarmVolume = aVolume;
            } else if (aDelta < 0) {
                textView.setText("Alarm Volume Increased");
                alarmVolume = aVolume;
            }
        }
    }
}
