<?php include 'htmLawed.php'; ?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>XSS Prevention</title>
        <style>
            .input {
                width: 100%;
            }
            strong {
                font-size: 14px;
            }
            .output {
                width: 100%;
                background: #efffef;
                padding: 5px;
            }
        </style>
    </head>
    <body>
        <form method="post">
            <strong>Input</strong>
            <textarea class="input" name="content"><?= isset($_POST['content']) ? $_POST['content'] : "" ?></textarea>
            <input type="submit" name="filter" value="Filter"/>
        </form>
        <br/><br/>

        <strong>1. Fully Secured </strong>
        <div class="output">
            <xmp>
                <?php
                if (isset($_POST['content'])) {
                    $config = array('safe' => 1);
                    echo htmLawed($_POST['content'], $config);
                }
                ?>
            </xmp>
        </div>
        <br/>

        <strong>2. Allow All</strong>
        <div class="output">
            <xmp>
                <?php
                if (isset($_POST['content'])) {
                    $config = array('comment' => 0, 'cdata' => 1);
                    echo htmLawed($_POST['content'], $config);
                }
                ?>
            </xmp>
        </div>
        <br/>
        
        <strong>3. Allow All Elements except "-applet -audio -canvas -embed -iframe -object -script -video" and allow all attributes and schemes</strong>
        <div class="output">
            <xmp>
                <?php
                if (isset($_POST['content'])) {
                    $config = array('comment' => 0, 'cdata' => 1,
                        'elements' => '* -applet -audio -canvas -embed -iframe -object -script -video');
                    echo htmLawed($_POST['content'], $config);
                }
                ?>
            </xmp>
        </div>
        <br/>

        <strong>4. Allow All Elements except "-applet -audio -canvas -embed -iframe -object -script -video" and deny all event attributes and allow all schemes</strong>
        <div class="output">
            <xmp>
                <?php
                if (isset($_POST['content'])) {
                    $config = array('comment' => 0, 'cdata' => 1,
                        'elements' => '* -applet -audio -canvas -embed -iframe -object -script -video',
                        'deny_attribute' => 'on*');
                    echo htmLawed($_POST['content'], $config);
                }
                ?>
            </xmp>
        </div>
        <br/>

        <strong>5. Allow All Elements except "-applet -audio -canvas -embed -iframe -object -script -video" and deny all event attributes and allow http url in href and no urls in style schemes</strong>
        <div class="output">
            <xmp>
                <?php
                if (isset($_POST['content'])) {
                    $config = array('comment' => 0, 'cdata' => 1,
                        'elements' => '* -applet -audio -canvas -embed -iframe -object -script -video',
                        'deny_attribute' => 'on*',
                        'schemes' => 'href: http; style: !');
                    echo htmLawed($_POST['content'], $config);
                }
                ?>
            </xmp>
        </div>
    </body>
</html>
